
![[Pasted image 20250527102638.png]]

### **Overview of Cisco ISE**

- **Centralized Policy Management**: Cisco ISE provides a unified platform to manage network access and usage policies from a single location.
- **Access Control Across Connection Types**: Supports wired, wireless, and remote VPN connections, ensuring consistent access control regardless of connection type.
- **Guest and Mobility Management**: Regulates guest and enterprise mobility access to internal and external resources with automated rules for guest sponsorships.
- **Regulatory Compliance**: Ensures compliance with government and industry standards by sharing information with Cisco Eco partner systems via pxGrid.

### **Cisco ISE AAA RADIUS Services**

- **Authentication Methods**:
- **802.1X Authentication**: For wired and wireless corporate employee access.
- **MAC Authentication Bypass (MAB)**: For devices without 802.1X capability, such as printers and IP cameras.
- **Web Authentication**: For guest access.
- **Authorization and Accounting**:
- Authorization profiles control user actions based on identity and session attributes.
- Accounting tracks user activities, including login times and accessed resources.

### **Posture Compliance and MDM Integration**

- **Posture Assessment**:
- Validates endpoint security (e.g., OS patches, antivirus updates).
- Grants elevated access for compliant devices using RADIUS Change of Authorization (CoA).
- Noncompliant devices are restricted and directed to remediation.
- **MDM Integration**: Enhances compliance by integrating with third-party MDM platforms for device control and security.

### **Profiling Service**

![[Pasted image 20250527103605.png]]

- **Device Classification**:
- Identifies endpoint types (e.g., Android, iPad) based on network interactions.
- Stores profiling results in an internal database for streamlined authorization.
- **Granular Policy Creation**:
- Enables context-based policies, such as limiting access for personal devices in public locations while granting elevated access for corporate devices in secure environments.

### **Device Onboarding and BYOD Support**

- **Self-Registration Portal**:
- Simplifies onboarding for personal devices with minimal IT intervention.
- Automates provisioning of certificates and configuration parameters.
- **MDM Integration**:
- Ensures compliance with corporate policies, such as patch levels and virus updates.
- Monitors and limits local application usage to secure corporate data.

### **Guest Management**

- **Guest Access Portals**:
- Offers Sponsored Guest, Self-Registered Guest, and Hotspot Guest Portals.
- Customizable portals tailored to enterprise needs.

### **Key Benefits**

- **Enhanced Security**: Combines zero-trust principles with network access control.
- **Operational Efficiency**: Centralized management reduces complexity and improves scalability.
- **Integration with Ecosystem**: Supports over 100 integrations with Cisco and third-party products for threat detection and response.